/*
 * Decompiled with CFR 0.152.
 */
package com.thq.Turrican;

import com.thq.Turrican.GameState;

public class CutScene {
    public boolean complete = true;
    int[][] sequence;
    int stepIndex = -1;
    long currentTime;
    long lastStepTime;
    long stepDuration;
    boolean autoFocusActive = false;

    public void updateCutScene() {
        this.currentTime = System.currentTimeMillis();
        if (this.currentTime - this.lastStepTime >= this.stepDuration) {
            if (++this.stepIndex == this.sequence.length) {
                this.complete = true;
                System.out.println("cut scene SCENE COMPLETE");
                return;
            }
            this.stepDuration = this.sequence[this.stepIndex][1];
            switch (this.sequence[this.stepIndex][0]) {
                case 0: {
                    this.spawnEntity(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3], this.sequence[this.stepIndex][4], this.sequence[this.stepIndex][5], this.sequence[this.stepIndex][6]);
                    break;
                }
                case 1: {
                    this.moveEntity(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3], this.sequence[this.stepIndex][4]);
                    break;
                }
                case 2: {
                    this.actionEntity(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3]);
                    break;
                }
                case 3: {
                    this.focusCamera(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3]);
                    break;
                }
                case 4: {
                    this.panCamera(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3], this.sequence[this.stepIndex][4], this.sequence[this.stepIndex][5]);
                    break;
                }
                case 5: {
                    GameState.player.startAction();
                    break;
                }
                case 6: {
                    GameState.player.stopAction();
                    GameState.player.doAction(0);
                    break;
                }
                case 7: {
                    GameState.hud.activateSprite(GameState.field_9c1[this.sequence[this.stepIndex][2]], this.sequence[this.stepIndex][2]);
                    this.autoFocusActive = true;
                    break;
                }
                case 8: {
                    this.autoFocusActive = false;
                    break;
                }
                case 9: {
                    GameState.camera.startShake(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3]);
                    break;
                }
                case 10: {
                    GameState.spritePool.setupSpriteEntry(this.sequence[this.stepIndex][2], this.sequence[this.stepIndex][3], this.sequence[this.stepIndex][4], this.sequence[this.stepIndex][5], this.sequence[this.stepIndex][6]);
                    break;
                }
                case 11: {
                    GameState.tileData[this.sequence[this.stepIndex][2]][this.sequence[this.stepIndex][3]] = (short)this.sequence[this.stepIndex][4];
                }
            }
            this.lastStepTime = this.currentTime;
        }
        if (this.autoFocusActive) {
            GameState.hud.showBossBar = true;
        }
    }

    public void startCutScene(int[][] var1) {
        this.complete = false;
        this.stepIndex = -1;
        this.sequence = var1;
        System.out.println("cut scene INIT");
    }

    public void stopCutScene() {
        this.complete = true;
    }

    private void focusCamera(int var1, int var2) {
        if (var1 == -1) {
            GameState.camera.focusOnEntity(var2);
        } else {
            GameState.camera.focusOn(var1, var2);
        }
        System.out.println("cut scene FOCUS CAMERA");
    }

    private void panCamera(int var1, int var2, int var3, int var4) {
        GameState.camera.checkTriggers(var1, var2, var3, var4);
        System.out.println("cut scene PAN CAMERA");
    }

    public void spawnEntity(int var1, int var2, int var3, int var4, int var5) {
        GameState.entityManager.spawnEntity(var1, var2, var3, var4, var5);
        System.out.println("cut scene SPAWN ENTITY " + var4 + " at " + var2 + "," + var3);
    }

    private void moveEntity(int var1, int var2, int var3) {
        GameState.entityManager.getEntityById(var1).moveTo(var2, var3);
        System.out.println("cut scene MOVE ENTITY " + var1 + " to " + var2 + "," + var3);
    }

    private void actionEntity(int var1, int var2) {
        GameState.entityManager.getEntityById(var1).doAction(var2);
        System.out.println("cut scene ACTION ENTITY " + var1 + " do " + var2);
    }
}

