/*
 * Decompiled with CFR 0.152.
 */
package com.thq.Turrican;

import com.thq.Turrican.GameScreen;
import com.thq.Turrican.GameState;

public class GameTrigger {
    public final byte MAX_CONDITIONS = (byte)5;
    public final byte MAX_ACTIONS = (byte)5;
    private byte conditionCount = 0;
    private byte actionCount = 0;
    private boolean conditionsMet = false;
    public boolean triggered = false;
    public byte[] conditionTypes = new byte[5];
    private int[] condX1 = new int[5];
    private int[] condY1 = new int[5];
    private int[] condX2 = new int[5];
    private int[] condY2 = new int[5];
    private byte[] condFlagIds = new byte[5];
    private long[] condFlagMasks = new long[5];
    private int[] actionData;
    private byte actionType = 0;
    private int tempPlayerX;
    private int tempPlayerY;

    public void addPositionCondition(int var1, int var2, int var3, int var4) {
        if (this.conditionCount != 5) {
            this.conditionTypes[this.conditionCount] = 0;
            this.condX1[this.conditionCount] = var1;
            this.condY1[this.conditionCount] = var2;
            this.condX2[this.conditionCount] = var3;
            this.condY2[this.conditionCount] = var4;
            this.conditionCount = (byte)(this.conditionCount + 1);
        }
    }

    public void vibrate(byte var1) {
        if (this.conditionCount != 5) {
            this.conditionTypes[this.conditionCount] = 1;
            this.condFlagIds[this.conditionCount] = var1;
            this.conditionCount = (byte)(this.conditionCount + 1);
        }
    }

    public void initGame(long var1) {
        if (this.conditionCount != 5) {
            this.conditionTypes[this.conditionCount] = 2;
            this.condFlagMasks[this.conditionCount] = var1;
            this.conditionCount = (byte)(this.conditionCount + 1);
        }
    }

    public void setSpawnAction(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6) {
        this.actionType = 0;
        this.actionData = new int[var1.length * 6 + 1];
        this.actionData[0] = var1.length;
        System.arraycopy(var1, 0, this.actionData, 1, this.actionData[0]);
        System.arraycopy(var2, 0, this.actionData, 1 + this.actionData[0] * 1, this.actionData[0]);
        System.arraycopy(var3, 0, this.actionData, 1 + this.actionData[0] * 2, this.actionData[0]);
        System.arraycopy(var4, 0, this.actionData, 1 + this.actionData[0] * 3, this.actionData[0]);
        System.arraycopy(var5, 0, this.actionData, 1 + this.actionData[0] * 4, this.actionData[0]);
        System.arraycopy(var6, 0, this.actionData, 1 + this.actionData[0] * 5, this.actionData[0]);
    }

    public void setTileAction(int[] var1, int[] var2, int[] var3) {
        this.actionType = 1;
        this.actionData = new int[var1.length * 5 + 1];
        this.actionData[0] = var1.length;
        System.arraycopy(var1, 0, this.actionData, 1, this.actionData[0]);
        System.arraycopy(var2, 0, this.actionData, 1 + this.actionData[0] * 1, this.actionData[0]);
        System.arraycopy(var3, 0, this.actionData, 1 + this.actionData[0] * 2, this.actionData[0]);
    }

    public void setRawAction(byte var1, int[] var2) {
        this.actionType = var1;
        this.actionData = var2;
    }

    public void checkTrigger() {
        if (!this.triggered) {
            this.conditionsMet = true;
            byte var1 = 0;
            while (var1 < this.conditionCount) {
                if (this.conditionTypes[var1] == 1) {
                    if (!GameState.isFlagSet(this.condFlagIds[var1])) {
                        this.conditionsMet = false;
                    }
                } else if (this.conditionTypes[var1] == 2) {
                    if (!GameState.areFlagsSet(this.condFlagMasks[var1])) {
                        this.conditionsMet = false;
                    }
                } else if (this.conditionTypes[var1] == 0) {
                    this.tempPlayerX = GameState.player.getX();
                    this.tempPlayerY = GameState.player.getY();
                    if (this.tempPlayerX < this.condX1[var1] || this.tempPlayerX > this.condX2[var1] || this.tempPlayerY < this.condY1[var1] || this.tempPlayerY > this.condY2[var1]) {
                        this.conditionsMet = false;
                    }
                }
                var1 = (byte)(var1 + 1);
            }
            if (this.conditionsMet) {
                this.setAction();
            }
        }
    }

    private void setAction() {
        if (this.actionType == 1) {
            int var1 = 0;
            while (var1 < this.actionData[0]) {
                GameState.tileData[this.actionData[1 + var1 + 0 * this.actionData[0]]][this.actionData[1 + var1 + 1 * this.actionData[0]]] = (short)this.actionData[1 + var1 + 2 * this.actionData[0]];
                ++var1;
            }
            this.triggered = true;
        } else if (this.actionType == 0) {
            int var1 = 0;
            while (var1 < this.actionData[0]) {
                if (this.actionData[1 + var1 + 5 * this.actionData[0]] > 0) {
                    GameState.entityManager.updateEntity(this.actionData[1 + var1 + 0 * this.actionData[0]], this.actionData[1 + var1 + 1 * this.actionData[0]], this.actionData[1 + var1 + 2 * this.actionData[0]], this.actionData[1 + var1 + 3 * this.actionData[0]], this.actionData[1 + var1 + 4 * this.actionData[0]], this.actionData[1 + var1 + 5 * this.actionData[0]]);
                } else if (!GameState.entityManager.spawnEntity(this.actionData[1 + var1 + 0 * this.actionData[0]], this.actionData[1 + var1 + 1 * this.actionData[0]], this.actionData[1 + var1 + 2 * this.actionData[0]], this.actionData[1 + var1 + 3 * this.actionData[0]], this.actionData[1 + var1 + 4 * this.actionData[0]])) {
                    System.out.println("ADD ENTITY FAILED!");
                    System.out.println(this.actionData[1 + var1 + 0 * this.actionData[0]]);
                    System.out.println(this.actionData[1 + var1 + 1 * this.actionData[0]]);
                    System.out.println(this.actionData[1 + var1 + 2 * this.actionData[0]]);
                    System.out.println(this.actionData[1 + var1 + 3 * this.actionData[0]]);
                    System.out.println(this.actionData[1 + var1 + 4 * this.actionData[0]]);
                }
                ++var1;
            }
            this.triggered = true;
        } else if (this.actionType == 2) {
            GameState.setFlag((byte)this.actionData[0]);
            this.triggered = true;
        } else if (this.actionType == 10) {
            GameState.levelComplete = true;
            if (!GameScreen.levelLoaded && !GameState.hud.isSpriteActive(this.actionData[0])) {
                GameState.hud.activateSprite(GameState.field_9c1[this.actionData[0]], this.actionData[0]);
            }
        } else if (this.actionType == 12) {
            GameState.cutScene.startCutScene(GameState.cutSceneData[this.actionData[0]]);
            this.triggered = true;
        } else if (this.actionType == 13) {
            GameState.currentLevel = this.actionData[0];
            this.triggered = true;
        } else if (this.actionType == 11) {
            GameState.player.setWeapon(this.actionData[0], this.actionData[1]);
            this.triggered = true;
        } else if (this.actionType == 14) {
            GameState.camera.startShake(this.actionData[0], this.actionData[0]);
        }
    }
}

