/*
 * Decompiled with CFR 0.152.
 */
package com.thq.Turrican;

import com.thq.Turrican.AnimatedSprite;
import com.thq.Turrican.GameEntity;
import com.thq.Turrican.GameScreen;
import com.thq.Turrican.GameState;
import com.thq.Turrican.ParticleSystem;
import javax.microedition.lcdui.Graphics;

public class PlayerCharacter
extends GameEntity {
    int posX = 0;
    final int STATE_IDLE;
    int posY = 0;
    int health = 100;
    boolean alive = true;
    int maxHealth = GameState.PLAYER_MAX_HEALTH;
    int[] arcTable;
    final int arcCenter;
    int arcIndex;
    int[] easeTable;
    int velX;
    int velY;
    boolean onGround;
    boolean facingRight;
    boolean jumping;
    int jumpVelY;
    boolean shooting;
    boolean running;
    boolean rolling;
    boolean crouching;
    boolean invincible;
    boolean dying;
    boolean dead;
    boolean falling;
    int shootCooldown;
    int invincibleTimer;
    int deathTimer;
    int animState;
    int weaponType;
    int weaponPower;
    int shieldCount;
    int bombCount;
    int energyCount;
    int[] spawnPos;
    int respawnX;
    int respawnY;
    boolean hasCheckpoint;
    int checkpointX;
    int checkpointY;
    boolean superMode;
    int superTimer;
    int field_a0e;
    int field_a18;
    int field_a8f;
    int field_ac9;
    int field_b60;
    int field_b9e;
    int field_bd4;
    int field_be0;
    int field_c22;
    int field_c51;
    public AnimatedSprite[] playerSprites;
    int field_cc3;
    int field_cd4;
    int field_cf7;
    int field_d1d;

    public PlayerCharacter() {
        this.STATE_IDLE = 0;
        int[] nArray = new int[18];
        nArray[0] = -4;
        nArray[1] = -3;
        nArray[2] = -2;
        nArray[3] = -2;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 4;
        this.arcTable = nArray;
        this.arcCenter = 9;
        this.arcIndex = 9;
        this.easeTable = new int[]{18, 17, 16, 13, 9, 7, 6, 5, 4, 3, 3, 2, 2, 2, 2, 2};
        this.velX = 0;
        this.onGround = false;
        this.facingRight = true;
        this.jumping = false;
        this.jumpVelY = 0;
        this.shooting = false;
        this.running = false;
        this.rolling = false;
        this.crouching = false;
        this.invincible = false;
        this.dying = false;
        this.dead = false;
        this.falling = false;
        this.shootCooldown = 0;
        this.invincibleTimer = -1;
        this.deathTimer = 0;
        this.animState = 0;
        this.weaponType = 0;
        this.weaponPower = 0;
        this.shieldCount = 0;
        this.bombCount = 0;
        this.energyCount = 0;
        this.respawnX = -1;
        this.respawnY = -1;
        this.hasCheckpoint = true;
        this.checkpointX = 0;
        this.checkpointY = 0;
        this.superMode = true;
        this.superTimer = -1;
        this.field_a0e = -1;
        this.field_a18 = -1;
        this.field_a8f = -1;
        this.field_ac9 = 1;
        this.field_b60 = 0;
        this.field_b9e = 0;
        this.field_bd4 = 0;
        this.field_c22 = 0;
        this.field_c51 = 0;
        this.field_cd4 = 0;
        this.field_cf7 = 0;
        this.field_d1d = 0;
    }

    public void update() {
        int var1 = 0;
        while (var1 < this.playerSprites.length) {
            this.playerSprites[var1].releaseState(this.spawnPos[var1]);
            ++var1;
        }
    }

    public void init(AnimatedSprite[] var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        this.playerSprites = var1;
        this.deathTimer = var2;
        this.animState = var3;
        this.field_b60 = var2;
        this.field_b9e = var3;
        this.weaponType = var4;
        this.weaponPower = var6;
        GameState.cameraX = this.deathTimer - 66;
        GameState.leftHeld = true;
        this.shieldCount = var5;
        this.spawnPos = new int[this.playerSprites.length];
        int var8 = 0;
        while (var8 < this.playerSprites.length) {
            this.spawnPos[var8] = this.playerSprites[var8].acquireState();
            ++var8;
        }
        this.field_be0 = var7;
        this.superTimer = var2;
        this.field_a0e = var3;
        this.field_a18 = var2;
        this.field_a8f = var3;
    }

    public void method_41() {
        this.bombCount = this.deathTimer - GameState.cameraX;
        this.energyCount = this.animState - GameState.cameraY;
        this.playerSprites[this.posX].saveAndRestoreState(this.spawnPos[this.posX]);
        this.playerSprites[this.posX].setTransform(this.weaponPower);
        this.playerSprites[this.posX].setPosition(this.bombCount, this.energyCount);
        this.field_cc3 = GameState.spritePool.method_1bd(this.playerSprites[this.posX], GameState.cameraX, GameState.cameraY, 1);
        this.health -= this.field_cc3 << 5;
        if (this.field_cc3 > 0) {
            GameScreen.vibrate(250);
        }
    }

    public void reset() {
        if (GameState.bossActive) {
            this.health = 100;
            this.field_c51 = 0;
            GameState.bossActive = false;
        }
        if (!this.jumping) {
            GameState.cameraX += 2;
            this.deathTimer += 2;
            if (this.method_9b()) {
                this.health -= 4;
            }
            if (this.deathTimer < GameState.cameraX + 16) {
                this.deathTimer = GameState.cameraX + 16;
            }
            if (this.deathTimer > GameState.cameraX + 132 - 16) {
                this.deathTimer = GameState.cameraX + 132 - 16;
            }
        }
        ++this.field_bd4;
        if (this.field_bd4 > this.maxHealth) {
            this.bombCount = GameState.player.getX();
            this.energyCount = GameState.player.getY();
            this.bombCount = Math.abs(this.deathTimer - this.bombCount);
            this.energyCount = Math.abs(this.animState - this.energyCount);
            this.bombCount *= this.bombCount;
            this.energyCount *= this.energyCount;
            if (this.bombCount + this.energyCount > GameState.SCORE_MAX) {
                this.health = -1;
            }
            this.field_bd4 = 0;
        }
        this.method_41();
        if (this.jumping) {
            if (this.jumpVelY-- < 0) {
                this.deathTimer = this.field_b60;
                this.animState = this.field_b9e;
                GameState.cameraX = this.field_b60 - 66;
                this.health = 100;
                int var10000 = GameScreen.gameManager.field_87b;
                GameScreen.gameManager.getClass();
                if (var10000 != 3) {
                    --GameState.weaponLevel;
                }
                this.jumping = false;
                GameState.bossDefeated = false;
            }
        } else if (this.health < 0 && !this.jumping) {
            GameState.spritePool.setupSpriteEntry(32, this.deathTimer, this.animState, 0, 0);
            GameState.spritePool.setupSpriteEntry(32, this.deathTimer - 5, this.animState - 5, 0, 0);
            GameState.spritePool.setupSpriteEntry(32, this.deathTimer - 5, this.animState + 5, 0, 0);
            GameState.spritePool.setupSpriteEntry(32, this.deathTimer + 5, this.animState - 5, 0, 0);
            GameState.spritePool.setupSpriteEntry(32, this.deathTimer + 5, this.animState + 5, 0, 0);
            if (this.weaponType < 256) {
                this.alive = false;
            } else {
                this.jumping = true;
                GameState.bossDefeated = true;
                this.jumpVelY = 10;
            }
            GameState.setFlag((byte)this.field_be0);
        } else {
            if (this.running) {
                this.rolling = GameState.keyUp;
                this.crouching = GameState.keyDown;
                this.invincible = GameState.keyLeft;
                this.dying = GameState.keyRight;
                this.dead = GameState.keyFire;
            } else {
                this.rolling = false;
                this.crouching = false;
                this.invincible = false;
                this.dying = false;
                this.dead = false;
                if (!this.hasCheckpoint && this.respawnX >= 0) {
                    if (Math.abs(this.respawnX - this.deathTimer) < 16) {
                        this.respawnX = -1;
                    } else if (this.respawnX <= this.deathTimer) {
                        this.rolling = true;
                    } else if (this.respawnX >= this.deathTimer) {
                        this.crouching = true;
                    }
                }
                if (this.respawnY >= 0) {
                    if (Math.abs(this.respawnY - this.animState) < 16) {
                        this.respawnY = -1;
                    } else if (this.respawnY < this.animState) {
                        this.invincible = true;
                    } else if (this.respawnY > this.animState) {
                        this.dying = true;
                    }
                }
                this.deathTimer += GameState.randomInt(2) - 1;
                this.animState += GameState.randomInt(2) - 1;
                this.hasCheckpoint = false;
            }
            if (this.respawnY < 0 && this.respawnX < 0) {
                if (this.field_ac9 == 1) {
                    this.respawnX = this.field_a18;
                    this.respawnY = this.field_a8f;
                    this.field_ac9 = 2;
                } else {
                    this.respawnX = this.superTimer;
                    this.respawnY = this.field_a0e;
                    this.field_ac9 = 1;
                }
            }
            this.posX = 0;
            if (this.rolling) {
                this.deathTimer -= 2;
                if (this.method_9b()) {
                    this.health -= 4;
                    this.deathTimer += 2;
                }
            }
            if (this.crouching) {
                this.deathTimer += 2;
                if (this.method_9b()) {
                    this.health -= 4;
                    this.deathTimer -= 2;
                }
            }
            if (!this.invincible && !this.dying) {
                if (this.velY < 2) {
                    ++this.velY;
                } else if (this.velY > 2) {
                    --this.velY;
                }
                if (this.arcIndex > 9) {
                    --this.arcIndex;
                } else if (this.arcIndex < 9) {
                    ++this.arcIndex;
                }
            }
            if (this.invincible) {
                if (this.velY > 0) {
                    --this.velY;
                }
                if (this.arcIndex > 0) {
                    --this.arcIndex;
                }
            }
            if (this.dying) {
                if (this.velY < 4) {
                    ++this.velY;
                }
                if (this.arcIndex < this.arcTable.length - 1) {
                    ++this.arcIndex;
                }
            }
            this.animState += this.arcTable[this.arcIndex];
            if (this.method_9b()) {
                this.animState -= this.arcTable[this.arcIndex];
                this.health -= 4;
            }
            if (this.dead && this.posY == 0) {
                switch (this.field_c51) {
                    case 0: {
                        GameState.spritePool.setupSpriteEntry(15, this.deathTimer + 14, this.animState, 12, 0);
                        this.posY = 8;
                        break;
                    }
                    case 1: {
                        GameState.spritePool.setupSpriteEntry(15, this.deathTimer + 14, this.animState, 12, 0);
                        this.posY = 8;
                        break;
                    }
                    case 2: {
                        GameState.spritePool.setupSpriteEntry(17, this.deathTimer + 14, this.animState, 12, 0);
                        this.posY = 8;
                        break;
                    }
                    case 3: {
                        GameState.spritePool.setupSpriteEntry(19, this.deathTimer + 14, this.animState, 12, 0);
                        this.posY = 5;
                        break;
                    }
                    case 4: {
                        GameState.spritePool.setupSpriteEntry(21, this.deathTimer + 14, this.animState, 12, 0);
                        this.posY = 5;
                    }
                }
            }
            if (this.posY > 0) {
                --this.posY;
            }
            GameState.PLAYER_START_HEALTH = this.health;
            this.field_c22 += 4;
            if (this.field_c22 > 359) {
                this.field_c22 -= 359;
            }
        }
    }

    public boolean method_9b() {
        try {
            this.field_cd4 = GameState.tileData[this.deathTimer * 2731 >> 16][(this.animState + this.playerSprites[this.posX].halfHeight) * 2731 >> 16];
            return this.field_cd4 > 0 && this.field_cd4 < GameState.hud.extra4;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public void draw(Graphics var1, int var2, int var3) {
        this.bombCount = this.deathTimer - GameState.cameraX;
        this.energyCount = this.animState - GameState.cameraY;
        this.playerSprites[this.posX].saveAndRestoreState(this.spawnPos[this.posX]);
        this.playerSprites[this.posX].setTransform(this.weaponPower);
        this.playerSprites[this.posX].setFrame(this.velY);
        this.playerSprites[this.posX].setPosition(this.bombCount, this.energyCount);
        if (this.jumping) {
            if ((this.jumpVelY & 1) == 0) {
                this.playerSprites[this.posX].drawSprite(var1);
            }
        } else {
            this.playerSprites[this.posX].drawSprite(var1);
        }
        if (this.field_c51 > 0) {
            this.method_f0(var1, this.field_c22, 45, 0);
        }
        if (this.field_c51 > 1) {
            this.method_f0(var1, this.field_c22 + 180, 45, 0);
        }
    }

    public boolean isActive() {
        return this.alive;
    }

    public int getX() {
        return this.deathTimer;
    }

    public int getY() {
        return this.animState;
    }

    public int getWidth() {
        return this.shieldCount;
    }

    public int getHeight() {
        return this.weaponPower;
    }

    public void startAction() {
        this.running = true;
    }

    public void stopAction() {
        this.running = false;
    }

    public boolean moveTo(int var1, int var2) {
        this.respawnX = var1;
        this.respawnY = var2;
        this.hasCheckpoint = false;
        this.superMode = false;
        return true;
    }

    public boolean doAction(int var1) {
        this.superMode = false;
        if (var1 != 0 && var1 != 1) {
            this.checkpointY = var1;
        } else {
            this.checkpointX = var1;
        }
        return true;
    }

    public int getType() {
        return this.invincibleTimer;
    }

    public boolean setWeapon(int var1, int var2) {
        this.field_b60 = var1;
        this.field_b9e = var2;
        return true;
    }

    public AnimatedSprite getSprite() {
        this.bombCount = this.deathTimer - GameState.cameraX;
        this.energyCount = this.animState - GameState.cameraY;
        this.playerSprites[this.posX].saveAndRestoreState(this.spawnPos[this.posX]);
        this.playerSprites[this.posX].setTransform(this.weaponPower);
        this.playerSprites[this.posX].setPosition(this.bombCount, this.energyCount);
        return this.playerSprites[this.posX];
    }

    public int getParam(int var1) {
        this.health -= var1 << 2;
        if (var1 > 0) {
            GameScreen.vibrate(250);
        }
        return 0;
    }

    public void onHit(int var1, int var2, int var3) {
    }

    public void method_f0(Graphics var1, int var2, int var3, int var4) {
        if (var2 > 359) {
            var2 -= 359;
        }
        if (var2 < 0) {
            var2 += 359;
        }
        int var10001 = var3 * ParticleSystem.sinTable[var2 * 186413 >> 16];
        this.field_cf7 = var10001 - var4 * ParticleSystem.cosTable[var2 * 186413 >> 16];
        var10001 = var3 * ParticleSystem.cosTable[var2 * 186413 >> 16];
        this.field_d1d = var10001 + var4 * ParticleSystem.sinTable[var2 * 186413 >> 16];
        this.bombCount = this.deathTimer - GameState.cameraX + (this.field_cf7 >> 16);
        this.energyCount = this.animState - GameState.cameraY + (this.field_d1d >> 16);
        GameState.spriteEffect6.setPosition(this.bombCount, this.energyCount);
        GameState.spriteEffect6.drawSprite(var1);
        if (this.dead && this.posY == 4) {
            switch (this.field_c51) {
                case 0: {
                    GameState.spritePool.setupSpriteEntry(15, this.deathTimer + (this.field_cf7 >> 16) + 14, this.animState + (this.field_d1d >> 16), 12, 0);
                    break;
                }
                case 1: {
                    GameState.spritePool.setupSpriteEntry(15, this.deathTimer + (this.field_cf7 >> 16) + 14, this.animState + (this.field_d1d >> 16), 12, 0);
                    break;
                }
                case 2: {
                    GameState.spritePool.setupSpriteEntry(15, this.deathTimer + (this.field_cf7 >> 16) + 14, this.animState + (this.field_d1d >> 16), 12, 0);
                    break;
                }
                case 3: {
                    GameState.spritePool.setupSpriteEntry(17, this.deathTimer + (this.field_cf7 >> 16) + 14, this.animState + (this.field_d1d >> 16), 12, 0);
                    break;
                }
                case 4: {
                    GameState.spritePool.setupSpriteEntry(1, this.deathTimer + (this.field_cf7 >> 16), this.animState + (this.field_d1d >> 16), 9, -1);
                    GameState.spritePool.setupSpriteEntry(1, this.deathTimer + (this.field_cf7 >> 16), this.animState + (this.field_d1d >> 16), 12, 0);
                    GameState.spritePool.setupSpriteEntry(1, this.deathTimer + (this.field_cf7 >> 16), this.animState + (this.field_d1d >> 16), 9, 1);
                }
            }
        }
    }

    public boolean setAction(int var1) {
        this.method_139(1);
        return true;
    }

    public boolean method_139(int var1) {
        this.field_c51 += var1;
        if (this.field_c51 > 4) {
            this.field_c51 = 4;
        }
        return true;
    }
}

